#region References

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using gov.va.med.vbecs;
using gov.va.med.vbecs.Common;

using TABLE = gov.va.med.vbecs.Common.VbecsTables.BloodUnit;
using COMMENTS = gov.va.med.vbecs.Common.VbecsTables.CannedComment;

#endregion

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmDiscardQuarantine
	/// </summary>
	public class FrmDiscardQuarantine : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables

		private BOL.DiscardOrQuarantineBloodUnit _discardOrQuarantine = null;

		// DataTables that populate combo boxes
		private System.Data.DataTable _dtDiscardQuarantineDetails;
		private System.Data.DataTable _dtReleaseDetails;

		//private ArrayList _alValidationMessages;
		private ArrayList _validUnits;
		private ArrayList _expiredUnits;
		private ArrayList _crossMatchedUnits;
		private System.Data.DataTable _dtBloodUnits;
		private Hashtable _reimbursementCostsChanged;
		private bool _isLoading = false;
		private Guid _shipmentGuid = Guid.Empty;

		private Common.WorkloadProcessID _workloadProcessId = Common.WorkloadProcessID.Unknown;
	
		#endregion

		#region Form Controls
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.Panel pnlProcess;
		private System.Windows.Forms.GroupBox grpAction;
		private System.Windows.Forms.RadioButton rdoDiscard;
		private System.Windows.Forms.RadioButton rdoQuarantine;
		private System.Windows.Forms.RadioButton rdoRelease;
		private System.Windows.Forms.GroupBox grpDiscard;
		private System.Windows.Forms.Label lblDiscardDetails;
		private System.Windows.Forms.Label lblDiscardComment;
		private System.Windows.Forms.GroupBox grpCredit;
		private System.Windows.Forms.RadioButton rdoCredit;
		private System.Windows.Forms.RadioButton rdoWaste;
		private System.Windows.Forms.GroupBox grpQuarantine;
		private System.Windows.Forms.Label lblQuarantineComment;
		private System.Windows.Forms.Label lblQuarantineDetails;
		private System.Windows.Forms.GroupBox grpRelease;
		private System.Windows.Forms.TextBox txtDiscardDetails;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbDiscardComment;
		private System.Windows.Forms.TextBox txtQuarantineDetails;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbQuarantineComment;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox2;
		private System.Windows.Forms.Panel pnlWorklist;
		private System.Windows.Forms.GroupBox grpUnits;
		private System.Windows.Forms.ListView lstUnits;
		private System.Windows.Forms.ColumnHeader colUnitID;
		private System.Windows.Forms.ColumnHeader colFullProductCode;
		private System.Windows.Forms.ColumnHeader colCredit;
		private gov.va.med.vbecs.GUI.controls.WorklistBuilder worklistBuilder1;
		private System.Windows.Forms.ColumnHeader colStatus;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnSave;
		private System.Windows.Forms.Label lblDateTime1;
		private System.Windows.Forms.Label lblDateTime2;
		private System.Windows.Forms.Label lblDateTime3;
		private System.Windows.Forms.ColumnHeader colQuarantine;
		private System.Windows.Forms.Label lblReleaseDetails;
		private System.Windows.Forms.TextBox txtReleaseDetails;
		private System.Windows.Forms.DateTimePicker dtDiscard;
		private System.Windows.Forms.DateTimePicker dtQuarantine;
		private System.Windows.Forms.DateTimePicker dtRemove;
		private System.Windows.Forms.ToolTip toolTip1;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbRemoveComment;
		private System.Windows.Forms.Label lblReleaseComment;
		private System.Windows.Forms.ColumnHeader colProductName;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Constructors/Dispose

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmDiscardQuarantine()
		{
			_isLoading = true;
			_reimbursementCostsChanged = new Hashtable();
			InitializeComponent();
			SetComponentProperties();
			Initialize();
			_isLoading = false;
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC027.FrmDiscardQuarantine_UnitSearch());
			this.lstUnits.Focus();
		}

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="shipmentGuid"></param>
		public FrmDiscardQuarantine(System.Guid shipmentGuid)
		{
			//
			this._shipmentGuid = shipmentGuid;
			//
			// Required for Windows Form Designer support
			//
			_isLoading = true;
			InitializeComponent();
			_dtBloodUnits = BOL.BloodUnit.GetBloodUnits(shipmentGuid);
			//
			this.worklistBuilder1.DTBloodUnits = _dtBloodUnits;
			SetComponentProperties();
			Initialize();
			_isLoading = false;
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC027.FrmDiscardQuarantine_Shipment());
			this.lstUnits.Focus();
		}

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="bloodUnit"></param>
		public FrmDiscardQuarantine(BOL.BloodUnit bloodUnit)
		{
			_isLoading = true;
			InitializeComponent();
			SetComponentProperties();
			Initialize();
			this.pnlWorklist.Visible = false;
			this.pnlProcess.Visible = true;
			this.dtRemove.Visible = true;
            //CR3554
            if (_discardOrQuarantine != null && _discardOrQuarantine.BloodUnits != null)
			    _discardOrQuarantine.BloodUnits.Add(bloodUnit);
			this.PopulateListView();
			this.rdoDiscard.Enabled = false;
			this.rdoQuarantine.Enabled = false;
			//
			this.PopulateCommentComboBoxes();
			//
			// Select the Release radio-button and then fire the corresponding event
			this.rdoRelease.Checked = true;
			this.rdoRelease_Click(null, new System.EventArgs());
			this._isLoading = false;
			this.lstUnits.Focus();
		}

		/// <summary>
		/// Dispose
		/// </summary>
		/// <param name="disposing"></param>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmDiscardQuarantine));
			this.btnCancel = new System.Windows.Forms.Button();
			this.pnlProcess = new System.Windows.Forms.Panel();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox2 = new System.Windows.Forms.PictureBox();
			this.grpAction = new System.Windows.Forms.GroupBox();
			this.rdoRelease = new System.Windows.Forms.RadioButton();
			this.rdoQuarantine = new System.Windows.Forms.RadioButton();
			this.rdoDiscard = new System.Windows.Forms.RadioButton();
			this.grpUnits = new System.Windows.Forms.GroupBox();
			this.lstUnits = new System.Windows.Forms.ListView();
			this.colUnitID = new System.Windows.Forms.ColumnHeader();
			this.colProductName = new System.Windows.Forms.ColumnHeader();
			this.colFullProductCode = new System.Windows.Forms.ColumnHeader();
			this.colStatus = new System.Windows.Forms.ColumnHeader();
			this.colCredit = new System.Windows.Forms.ColumnHeader();
			this.colQuarantine = new System.Windows.Forms.ColumnHeader();
			this.grpDiscard = new System.Windows.Forms.GroupBox();
			this.dtDiscard = new System.Windows.Forms.DateTimePicker();
			this.lblDateTime3 = new System.Windows.Forms.Label();
			this.grpCredit = new System.Windows.Forms.GroupBox();
			this.rdoCredit = new System.Windows.Forms.RadioButton();
			this.rdoWaste = new System.Windows.Forms.RadioButton();
			this.txtDiscardDetails = new System.Windows.Forms.TextBox();
			this.lblDiscardComment = new System.Windows.Forms.Label();
			this.lblDiscardDetails = new System.Windows.Forms.Label();
			this.cmbDiscardComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.grpQuarantine = new System.Windows.Forms.GroupBox();
			this.dtQuarantine = new System.Windows.Forms.DateTimePicker();
			this.lblDateTime2 = new System.Windows.Forms.Label();
			this.txtQuarantineDetails = new System.Windows.Forms.TextBox();
			this.cmbQuarantineComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblQuarantineComment = new System.Windows.Forms.Label();
			this.lblQuarantineDetails = new System.Windows.Forms.Label();
			this.grpRelease = new System.Windows.Forms.GroupBox();
			this.lblReleaseComment = new System.Windows.Forms.Label();
			this.cmbRemoveComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.txtReleaseDetails = new System.Windows.Forms.TextBox();
			this.lblReleaseDetails = new System.Windows.Forms.Label();
			this.lblDateTime1 = new System.Windows.Forms.Label();
			this.dtRemove = new System.Windows.Forms.DateTimePicker();
			this.pnlWorklist = new System.Windows.Forms.Panel();
			this.worklistBuilder1 = new gov.va.med.vbecs.GUI.controls.WorklistBuilder(this.components);
			this.btnSave = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.pnlProcess.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.grpAction.SuspendLayout();
			this.grpUnits.SuspendLayout();
			this.grpDiscard.SuspendLayout();
			this.grpCredit.SuspendLayout();
			this.grpQuarantine.SuspendLayout();
			this.grpRelease.SuspendLayout();
			this.pnlWorklist.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(600, 30);
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(520, 448);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 13;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// pnlProcess
			// 
			this.pnlProcess.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlProcess.Controls.Add(this.grpImage);
			this.pnlProcess.Controls.Add(this.grpAction);
			this.pnlProcess.Controls.Add(this.grpUnits);
			this.pnlProcess.Controls.Add(this.grpDiscard);
			this.pnlProcess.Controls.Add(this.grpQuarantine);
			this.pnlProcess.Controls.Add(this.grpRelease);
			this.pnlProcess.Location = new System.Drawing.Point(4, 36);
			this.pnlProcess.Name = "pnlProcess";
			this.pnlProcess.Size = new System.Drawing.Size(592, 408);
			this.pnlProcess.TabIndex = 1;
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.BackColor = System.Drawing.SystemColors.Control;
			this.grpImage.Controls.Add(this.pictureBox2);
			this.grpImage.Location = new System.Drawing.Point(0, 4);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 400);
			this.grpImage.TabIndex = 45;
			this.grpImage.TabStop = false;
			// 
			// pictureBox2
			// 
			this.pictureBox2.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox2.Image")));
			this.pictureBox2.Location = new System.Drawing.Point(4, 12);
			this.pictureBox2.Name = "pictureBox2";
			this.pictureBox2.Size = new System.Drawing.Size(45, 45);
			this.pictureBox2.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox2.TabIndex = 38;
			this.pictureBox2.TabStop = false;
			// 
			// grpAction
			// 
			this.grpAction.AccessibleDescription = "Activity";
			this.grpAction.AccessibleName = "Activity";
			this.grpAction.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.grpAction.Controls.Add(this.rdoRelease);
			this.grpAction.Controls.Add(this.rdoQuarantine);
			this.grpAction.Controls.Add(this.rdoDiscard);
			this.grpAction.Location = new System.Drawing.Point(56, 300);
			this.grpAction.Name = "grpAction";
			this.grpAction.Size = new System.Drawing.Size(116, 104);
			this.grpAction.TabIndex = 1;
			this.grpAction.TabStop = false;
			this.grpAction.Text = "Activity*";
			// 
			// rdoRelease
			// 
			this.rdoRelease.AccessibleDescription = "Release from Quarantine";
			this.rdoRelease.AccessibleName = "Release from Quarantine";
			this.rdoRelease.Location = new System.Drawing.Point(8, 64);
			this.rdoRelease.Name = "rdoRelease";
			this.rdoRelease.Size = new System.Drawing.Size(104, 36);
			this.rdoRelease.TabIndex = 4;
			this.rdoRelease.TabStop = true;
			this.rdoRelease.Text = "&Release from Quarantine";
			this.rdoRelease.Click += new System.EventHandler(this.rdoRelease_Click);
			// 
			// rdoQuarantine
			// 
			this.rdoQuarantine.AccessibleDescription = "Quarantine";
			this.rdoQuarantine.AccessibleName = "Quarantine";
			this.rdoQuarantine.Location = new System.Drawing.Point(8, 42);
			this.rdoQuarantine.Name = "rdoQuarantine";
			this.rdoQuarantine.Size = new System.Drawing.Size(80, 24);
			this.rdoQuarantine.TabIndex = 3;
			this.rdoQuarantine.TabStop = true;
			this.rdoQuarantine.Text = "&Quarantine";
			this.rdoQuarantine.Click += new System.EventHandler(this.rdoQuarantine_Click);
			// 
			// rdoDiscard
			// 
			this.rdoDiscard.AccessibleDescription = "Discard";
			this.rdoDiscard.AccessibleName = "Discard";
			this.rdoDiscard.Location = new System.Drawing.Point(8, 16);
			this.rdoDiscard.Name = "rdoDiscard";
			this.rdoDiscard.Size = new System.Drawing.Size(80, 24);
			this.rdoDiscard.TabIndex = 2;
			this.rdoDiscard.TabStop = true;
			this.rdoDiscard.Text = "&Discard";
			this.rdoDiscard.Click += new System.EventHandler(this.rdoDiscard_Click);
			// 
			// grpUnits
			// 
			this.grpUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpUnits.Controls.Add(this.lstUnits);
			this.grpUnits.Location = new System.Drawing.Point(56, 4);
			this.grpUnits.Name = "grpUnits";
			this.grpUnits.Size = new System.Drawing.Size(536, 292);
			this.grpUnits.TabIndex = 0;
			this.grpUnits.TabStop = false;
			// 
			// lstUnits
			// 
			this.lstUnits.AccessibleDescription = "Units";
			this.lstUnits.AccessibleName = "Units";
			this.lstUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lstUnits.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																					   this.colUnitID,
																					   this.colProductName,
																					   this.colFullProductCode,
																					   this.colStatus,
																					   this.colCredit,
																					   this.colQuarantine});
			this.lstUnits.FullRowSelect = true;
			this.lstUnits.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
			this.lstUnits.Location = new System.Drawing.Point(8, 16);
			this.lstUnits.Name = "lstUnits";
			this.lstUnits.Size = new System.Drawing.Size(520, 268);
			this.lstUnits.TabIndex = 0;
			this.lstUnits.View = System.Windows.Forms.View.Details;
			this.lstUnits.Click += new System.EventHandler(this.ChangeCredit);
			this.lstUnits.ItemActivate += new System.EventHandler(this.ChangeCredit);
			// 
			// colUnitID
			// 
			this.colUnitID.Text = "Unit ID";
			this.colUnitID.Width = 100;
			// 
			// colProductName
			// 
			this.colProductName.Text = "Product Name";
			this.colProductName.Width = 100;
			// 
			// colFullProductCode
			// 
			this.colFullProductCode.Text = "Code";
			// 
			// colStatus
			// 
			this.colStatus.Text = "Status";
			this.colStatus.Width = 120;
			// 
			// colCredit
			// 
			this.colCredit.Text = "Credit";
			this.colCredit.Width = 45;
			// 
			// colQuarantine
			// 
			this.colQuarantine.Text = "Quarantined?";
			this.colQuarantine.Width = 90;
			// 
			// grpDiscard
			// 
			this.grpDiscard.AccessibleDescription = "Discard Units";
			this.grpDiscard.AccessibleName = "Discard Units";
			this.grpDiscard.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpDiscard.Controls.Add(this.dtDiscard);
			this.grpDiscard.Controls.Add(this.lblDateTime3);
			this.grpDiscard.Controls.Add(this.grpCredit);
			this.grpDiscard.Controls.Add(this.txtDiscardDetails);
			this.grpDiscard.Controls.Add(this.lblDiscardComment);
			this.grpDiscard.Controls.Add(this.lblDiscardDetails);
			this.grpDiscard.Controls.Add(this.cmbDiscardComment);
			this.grpDiscard.Location = new System.Drawing.Point(176, 300);
			this.grpDiscard.Name = "grpDiscard";
			this.grpDiscard.Size = new System.Drawing.Size(412, 104);
			this.grpDiscard.TabIndex = 5;
			this.grpDiscard.TabStop = false;
			this.grpDiscard.Text = "Discard Unit(s)";
			// 
			// dtDiscard
			// 
			this.dtDiscard.AccessibleDescription = "Discard Date";
			this.dtDiscard.AccessibleName = "Discard Date";
			this.dtDiscard.CustomFormat = "";
			this.dtDiscard.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtDiscard.Location = new System.Drawing.Point(80, 76);
			this.dtDiscard.Name = "dtDiscard";
			this.dtDiscard.Size = new System.Drawing.Size(144, 20);
			this.dtDiscard.TabIndex = 8;
			this.dtDiscard.ValueChanged += new System.EventHandler(this.dtDiscard_ValueChanged);
			// 
			// lblDateTime3
			// 
			this.lblDateTime3.Location = new System.Drawing.Point(8, 80);
			this.lblDateTime3.Name = "lblDateTime3";
			this.lblDateTime3.Size = new System.Drawing.Size(80, 12);
			this.lblDateTime3.TabIndex = 3;
			this.lblDateTime3.Text = "Discard Date*";
			// 
			// grpCredit
			// 
			this.grpCredit.AccessibleDescription = "Reimbursement";
			this.grpCredit.AccessibleName = "Reimbursement";
			this.grpCredit.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.grpCredit.Controls.Add(this.rdoCredit);
			this.grpCredit.Controls.Add(this.rdoWaste);
			this.grpCredit.Location = new System.Drawing.Point(296, 8);
			this.grpCredit.Name = "grpCredit";
			this.grpCredit.Size = new System.Drawing.Size(108, 68);
			this.grpCredit.TabIndex = 9;
			this.grpCredit.TabStop = false;
			this.grpCredit.Text = "Reimbursement*";
			// 
			// rdoCredit
			// 
			this.rdoCredit.Location = new System.Drawing.Point(8, 40);
			this.rdoCredit.Name = "rdoCredit";
			this.rdoCredit.Size = new System.Drawing.Size(68, 24);
			this.rdoCredit.TabIndex = 11;
			this.rdoCredit.Text = "Cr&edit";
			this.rdoCredit.Click += new System.EventHandler(this.rdoCredit_Click);
			// 
			// rdoWaste
			// 
			this.rdoWaste.Location = new System.Drawing.Point(8, 16);
			this.rdoWaste.Name = "rdoWaste";
			this.rdoWaste.Size = new System.Drawing.Size(68, 24);
			this.rdoWaste.TabIndex = 10;
			this.rdoWaste.TabStop = true;
			this.rdoWaste.Text = "&Waste";
			this.rdoWaste.Click += new System.EventHandler(this.rdoWaste_Click);
			// 
			// txtDiscardDetails
			// 
			this.txtDiscardDetails.AccessibleDescription = "Details";
			this.txtDiscardDetails.AccessibleName = "Details";
			this.txtDiscardDetails.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtDiscardDetails.Location = new System.Drawing.Point(80, 48);
			this.txtDiscardDetails.MaxLength = 255;
			this.txtDiscardDetails.Multiline = true;
			this.txtDiscardDetails.Name = "txtDiscardDetails";
			this.txtDiscardDetails.Size = new System.Drawing.Size(200, 20);
			this.txtDiscardDetails.TabIndex = 7;
			this.txtDiscardDetails.Text = "";
			this.txtDiscardDetails.Leave += new System.EventHandler(this.txtDiscardDetails_Leave);
			this.txtDiscardDetails.KeyUp += new System.Windows.Forms.KeyEventHandler(this.txtDiscardDetails_KeyUp);
			// 
			// lblDiscardComment
			// 
			this.lblDiscardComment.Location = new System.Drawing.Point(8, 18);
			this.lblDiscardComment.Name = "lblDiscardComment";
			this.lblDiscardComment.Size = new System.Drawing.Size(60, 23);
			this.lblDiscardComment.TabIndex = 1;
			this.lblDiscardComment.Text = "Comment*";
			this.lblDiscardComment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblDiscardDetails
			// 
			this.lblDiscardDetails.Location = new System.Drawing.Point(8, 46);
			this.lblDiscardDetails.Name = "lblDiscardDetails";
			this.lblDiscardDetails.Size = new System.Drawing.Size(56, 23);
			this.lblDiscardDetails.TabIndex = 0;
			this.lblDiscardDetails.Text = "Details";
			this.lblDiscardDetails.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cmbDiscardComment
			// 
			this.cmbDiscardComment.AccessibleDescription = "Comment*";
			this.cmbDiscardComment.AccessibleName = "Comment*";
			this.cmbDiscardComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbDiscardComment.Interval = 500;
			this.cmbDiscardComment.Location = new System.Drawing.Point(80, 20);
			this.cmbDiscardComment.MaxLength = 80;
			this.cmbDiscardComment.Name = "cmbDiscardComment";
			this.cmbDiscardComment.Size = new System.Drawing.Size(200, 22);
			this.cmbDiscardComment.TabIndex = 6;
			this.cmbDiscardComment.SelectedIndexChanged += new System.EventHandler(this.cmbDiscardComment_SelectedIndexChanged);
			// 
			// grpQuarantine
			// 
			this.grpQuarantine.AccessibleDescription = "Quarantine Units";
			this.grpQuarantine.AccessibleName = "Quarantine Units";
			this.grpQuarantine.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpQuarantine.Controls.Add(this.dtQuarantine);
			this.grpQuarantine.Controls.Add(this.lblDateTime2);
			this.grpQuarantine.Controls.Add(this.txtQuarantineDetails);
			this.grpQuarantine.Controls.Add(this.cmbQuarantineComment);
			this.grpQuarantine.Controls.Add(this.lblQuarantineComment);
			this.grpQuarantine.Controls.Add(this.lblQuarantineDetails);
			this.grpQuarantine.Location = new System.Drawing.Point(176, 300);
			this.grpQuarantine.Name = "grpQuarantine";
			this.grpQuarantine.Size = new System.Drawing.Size(416, 104);
			this.grpQuarantine.TabIndex = 5;
			this.grpQuarantine.TabStop = false;
			this.grpQuarantine.Text = "Quarantine Unit(s)";
			this.grpQuarantine.Visible = false;
			// 
			// dtQuarantine
			// 
			this.dtQuarantine.AccessibleDescription = "Quarantine Date";
			this.dtQuarantine.AccessibleName = "Quarantine Date";
			this.dtQuarantine.CustomFormat = "";
			this.dtQuarantine.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtQuarantine.Location = new System.Drawing.Point(96, 76);
			this.dtQuarantine.Name = "dtQuarantine";
			this.dtQuarantine.Size = new System.Drawing.Size(128, 20);
			this.dtQuarantine.TabIndex = 8;
			this.dtQuarantine.ValueChanged += new System.EventHandler(this.dtQuarantine_ValueChanged);
			// 
			// lblDateTime2
			// 
			this.lblDateTime2.Location = new System.Drawing.Point(8, 76);
			this.lblDateTime2.Name = "lblDateTime2";
			this.lblDateTime2.Size = new System.Drawing.Size(96, 16);
			this.lblDateTime2.TabIndex = 2;
			this.lblDateTime2.Text = "Quarantine Date*";
			// 
			// txtQuarantineDetails
			// 
			this.txtQuarantineDetails.AccessibleDescription = "Details";
			this.txtQuarantineDetails.AccessibleName = "Details";
			this.txtQuarantineDetails.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtQuarantineDetails.Location = new System.Drawing.Point(96, 48);
			this.txtQuarantineDetails.MaxLength = 255;
			this.txtQuarantineDetails.Name = "txtQuarantineDetails";
			this.txtQuarantineDetails.Size = new System.Drawing.Size(308, 20);
			this.txtQuarantineDetails.TabIndex = 7;
			this.txtQuarantineDetails.Text = "";
			this.txtQuarantineDetails.Leave += new System.EventHandler(this.txtQuarantineDetails_Leave);
			this.txtQuarantineDetails.KeyUp += new System.Windows.Forms.KeyEventHandler(this.txtQuarantineDetails_KeyUp);
			// 
			// cmbQuarantineComment
			// 
			this.cmbQuarantineComment.AccessibleDescription = "Comment";
			this.cmbQuarantineComment.AccessibleName = "Comment";
			this.cmbQuarantineComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbQuarantineComment.Interval = 500;
			this.cmbQuarantineComment.Location = new System.Drawing.Point(96, 20);
			this.cmbQuarantineComment.MaxLength = 80;
			this.cmbQuarantineComment.Name = "cmbQuarantineComment";
			this.cmbQuarantineComment.Size = new System.Drawing.Size(308, 22);
			this.cmbQuarantineComment.TabIndex = 6;
			this.cmbQuarantineComment.SelectedIndexChanged += new System.EventHandler(this.cmbQuarantineComment_SelectedIndexChanged);
			// 
			// lblQuarantineComment
			// 
			this.lblQuarantineComment.Location = new System.Drawing.Point(8, 18);
			this.lblQuarantineComment.Name = "lblQuarantineComment";
			this.lblQuarantineComment.Size = new System.Drawing.Size(60, 23);
			this.lblQuarantineComment.TabIndex = 1;
			this.lblQuarantineComment.Text = "Comment*";
			this.lblQuarantineComment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblQuarantineDetails
			// 
			this.lblQuarantineDetails.Location = new System.Drawing.Point(8, 48);
			this.lblQuarantineDetails.Name = "lblQuarantineDetails";
			this.lblQuarantineDetails.Size = new System.Drawing.Size(56, 23);
			this.lblQuarantineDetails.TabIndex = 0;
			this.lblQuarantineDetails.Text = "Details";
			this.lblQuarantineDetails.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpRelease
			// 
			this.grpRelease.AccessibleDescription = "Release units from quarantine";
			this.grpRelease.AccessibleName = "Release units from quarantine";
			this.grpRelease.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpRelease.Controls.Add(this.lblReleaseComment);
			this.grpRelease.Controls.Add(this.cmbRemoveComment);
			this.grpRelease.Controls.Add(this.txtReleaseDetails);
			this.grpRelease.Controls.Add(this.lblReleaseDetails);
			this.grpRelease.Controls.Add(this.lblDateTime1);
			this.grpRelease.Controls.Add(this.dtRemove);
			this.grpRelease.Location = new System.Drawing.Point(176, 300);
			this.grpRelease.Name = "grpRelease";
			this.grpRelease.Size = new System.Drawing.Size(412, 104);
			this.grpRelease.TabIndex = 5;
			this.grpRelease.TabStop = false;
			this.grpRelease.Text = "Release Unit(s) from Quarantine";
			this.grpRelease.Visible = false;
			// 
			// lblReleaseComment
			// 
			this.lblReleaseComment.Location = new System.Drawing.Point(8, 18);
			this.lblReleaseComment.Name = "lblReleaseComment";
			this.lblReleaseComment.Size = new System.Drawing.Size(64, 20);
			this.lblReleaseComment.TabIndex = 6;
			this.lblReleaseComment.Text = "Comment*";
			this.lblReleaseComment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cmbRemoveComment
			// 
			this.cmbRemoveComment.AccessibleDescription = "Comment";
			this.cmbRemoveComment.AccessibleName = "Comment";
			this.cmbRemoveComment.Interval = 500;
			this.cmbRemoveComment.Location = new System.Drawing.Point(96, 20);
			this.cmbRemoveComment.MaxLength = 80;
			this.cmbRemoveComment.Name = "cmbRemoveComment";
			this.cmbRemoveComment.Size = new System.Drawing.Size(308, 22);
			this.cmbRemoveComment.TabIndex = 6;
			this.cmbRemoveComment.SelectedIndexChanged += new System.EventHandler(this.cmbRemoveComment_SelectedIndexChanged);
			// 
			// txtReleaseDetails
			// 
			this.txtReleaseDetails.AccessibleDescription = "Details";
			this.txtReleaseDetails.AccessibleName = "Details";
			this.txtReleaseDetails.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtReleaseDetails.Location = new System.Drawing.Point(96, 48);
			this.txtReleaseDetails.MaxLength = 255;
			this.txtReleaseDetails.Name = "txtReleaseDetails";
			this.txtReleaseDetails.Size = new System.Drawing.Size(308, 20);
			this.txtReleaseDetails.TabIndex = 7;
			this.txtReleaseDetails.Text = "";
			this.txtReleaseDetails.Leave += new System.EventHandler(this.txtReleaseDetails_Leave);
			this.txtReleaseDetails.KeyUp += new System.Windows.Forms.KeyEventHandler(this.txtReleaseDetails_KeyUp);
			// 
			// lblReleaseDetails
			// 
			this.lblReleaseDetails.Location = new System.Drawing.Point(8, 48);
			this.lblReleaseDetails.Name = "lblReleaseDetails";
			this.lblReleaseDetails.Size = new System.Drawing.Size(56, 20);
			this.lblReleaseDetails.TabIndex = 4;
			this.lblReleaseDetails.Text = "Details";
			this.lblReleaseDetails.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblDateTime1
			// 
			this.lblDateTime1.Location = new System.Drawing.Point(8, 76);
			this.lblDateTime1.Name = "lblDateTime1";
			this.lblDateTime1.Size = new System.Drawing.Size(80, 20);
			this.lblDateTime1.TabIndex = 3;
			this.lblDateTime1.Text = "Release Date*";
			this.lblDateTime1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtRemove
			// 
			this.dtRemove.AccessibleDescription = "Release Date";
			this.dtRemove.AccessibleName = "Release Date";
			this.dtRemove.CustomFormat = "";
			this.dtRemove.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtRemove.Location = new System.Drawing.Point(96, 76);
			this.dtRemove.Name = "dtRemove";
			this.dtRemove.Size = new System.Drawing.Size(128, 20);
			this.dtRemove.TabIndex = 8;
			this.dtRemove.ValueChanged += new System.EventHandler(this.dtRemove_ValueChanged);
			// 
			// pnlWorklist
			// 
			this.pnlWorklist.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlWorklist.Controls.Add(this.worklistBuilder1);
			this.pnlWorklist.Location = new System.Drawing.Point(4, 36);
			this.pnlWorklist.Name = "pnlWorklist";
			this.pnlWorklist.Size = new System.Drawing.Size(596, 408);
			this.pnlWorklist.TabIndex = 0;
			// 
			// worklistBuilder1
			// 
			this.worklistBuilder1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.worklistBuilder1.CheckBoxes = true;
			this.worklistBuilder1.Location = new System.Drawing.Point(0, 4);
			this.worklistBuilder1.Name = "worklistBuilder1";
			this.worklistBuilder1.Size = new System.Drawing.Size(596, 396);
			this.worklistBuilder1.TabIndex = 0;
			this.worklistBuilder1.ValidWorklist += new System.EventHandler(this.worklistBuilder1_ValidWorklist);
			this.worklistBuilder1.SearchClick += new System.EventHandler(this.worklistBuilder1_SearchClick);
			this.worklistBuilder1.UnitsInList += new System.EventHandler(this.CheckValid);
			this.worklistBuilder1.ItemCheck += new System.EventHandler(this.worklistBuilder1_ItemCheck);
			// 
			// btnSave
			// 
			this.btnSave.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSave.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnSave.EnabledButton = false;
			this.btnSave.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnSave.Image = null;
			this.btnSave.Location = new System.Drawing.Point(440, 448);
			this.btnSave.Name = "btnSave";
			this.btnSave.Size = new System.Drawing.Size(75, 23);
			this.btnSave.TabIndex = 12;
			this.btnSave.Click += new System.EventHandler(this.btnSave_Click);
			this.btnSave.MouseHover += new System.EventHandler(this.btnSave_AnotherHover);
			// 
			// FrmDiscardQuarantine
			// 
			this.AcceptButton = this.btnSave;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(600, 473);
			this.Controls.Add(this.pnlWorklist);
			this.Controls.Add(this.pnlProcess);
			this.Controls.Add(this.btnSave);
			this.Controls.Add(this.btnCancel);
			this.hlphelpChm.SetHelpKeyword(this, "Discard_or_Quarantine.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(536, 400);
			this.Name = "FrmDiscardQuarantine";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Discard or Quarantine Units";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmDiscardQuarantine_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.btnSave, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.pnlProcess, 0);
			this.Controls.SetChildIndex(this.pnlWorklist, 0);
			this.pnlProcess.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.grpAction.ResumeLayout(false);
			this.grpUnits.ResumeLayout(false);
			this.grpDiscard.ResumeLayout(false);
			this.grpCredit.ResumeLayout(false);
			this.grpQuarantine.ResumeLayout(false);
			this.grpRelease.ResumeLayout(false);
			this.pnlWorklist.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion
		
		#region Methods

		/// <summary>
		/// Initialize
		/// </summary>
		public void Initialize() 
		{
			// Enable the Remove from Quarantine functionality only if the user is an enhanced technologist or higher.
			if (Convert.ToInt32(ThisUser.CurrentDivisionRole.Role.UserRoleId) < Convert.ToInt32(Common.UserRoleType.EnhancedTechnologist))
			{
				this.rdoRelease.Enabled = false;
			}

			_discardOrQuarantine = new BOL.DiscardOrQuarantineBloodUnit();
			_discardOrQuarantine.Valid += new System.EventHandler(OnValid);
			_discardOrQuarantine.Invalid += new System.EventHandler(OnInvalid);
			
			//setting the event to fire the setdirtyflag function
			_discardOrQuarantine.Invalid += new System.EventHandler(this.SetDirtyFlag);

			//Moved up from the PopulateComboBoxes method to speed Save_Click
			_dtDiscardQuarantineDetails = BOL.DiscardOrQuarantineBloodUnit.GetComboBoxEntries("QD");	
			_dtReleaseDetails = BOL.DiscardOrQuarantineBloodUnit.GetComboBoxEntries("QR");	
		}

		
		/// <summary>
		/// This method sets the controls to an initial state.
		/// </summary>
		/// <developers>
		///		<developer>Carl Jensen</developer>
		/// </developers>
		/// <date>11/11/02</date>
		private void SetComponentProperties()
		{
            this.LockController.LockFunction = Common.LockFunctions.UC027DiscardQuarantine;

			// 
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			this.pnlWorklist.Visible = true;
			this.pnlProcess.Visible = false;
			this.dtRemove.Visible = false;

			this.vbecsLogo1.Title = "Discard or Quarantine Units";
			this.RequiredFieldsLabel = true;

			this.rdoDiscard.Checked = true;
			this.rdoWaste.Checked = true;
			this.rdoRelease.Enabled = ThisUser.IsAuthorizedForFunction( Common.FunctionCode.ReleaseBloodproductsFromQuarantine );
			this.grpDiscard.Visible = (rdoDiscard.Checked);
			this.grpQuarantine.Visible = (rdoQuarantine.Checked);
			this.grpRelease.Visible = (rdoRelease.Checked);

			// set up the DateTimePickers
			this.dtRemove.Format = DateTimePickerFormat.Custom;
			this.dtRemove.CustomFormat = Common.VBECSDateTime.DateTimeFormat;

			this.dtQuarantine.Format = DateTimePickerFormat.Custom;
			this.dtQuarantine.CustomFormat = Common.VBECSDateTime.DateTimeFormat;

			this.dtDiscard.Format = DateTimePickerFormat.Custom;
			this.dtDiscard.CustomFormat = Common.VBECSDateTime.DateTimeFormat;

			//set current date value based on the division time zone
			System.DateTime _currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			
			this.dtRemove.MaxDate = _currentDate;
			this.dtQuarantine.MaxDate = _currentDate;
			this.dtDiscard.MaxDate = _currentDate;
				

			this.dtRemove.Value = _currentDate;
			this.dtQuarantine.Value = _currentDate;
			this.dtDiscard.Value = _currentDate;	
		}

		/// <summary>
		/// This method changes the return credit amount when the user selects it from the ListView.
		/// </summary>
		/// <developers>
		///		<developer>Carl Jensen</developer>
		/// </developers>
		/// <date>11/11/02</date>
		private void ChangeCredit(object sender, System.EventArgs e)
		{
			ListView lv = (ListView)sender;
		
			BOL.BloodUnit bloodUnit = (BOL.BloodUnit) lstUnits.SelectedItems[0].Tag;
			string selectedID = bloodUnit.EyeReadableUnitId;
			// BR_27.07
			decimal reimbursementCredit =  GetReimbursementCost(bloodUnit);
			
			if (this.rdoDiscard.Checked == true  && this.rdoCredit.Checked == true) 
			{
				DlgDiscardQuarantineChangeReimbursement dlg = new DlgDiscardQuarantineChangeReimbursement(selectedID, reimbursementCredit);
                dlg.ShowDialogFromLockedParent(this, false);

				if (dlg.DialogResult == DialogResult.OK) 
				{
					// find "clicked on" blood bag and update it
					foreach(BOL.BloodUnit bloodUnit2 in _discardOrQuarantine.BloodUnits) 
					{
						if (bloodUnit2.EyeReadableUnitId.Trim().Equals(selectedID)) 
						{
							bloodUnit2.BloodUnitFinance.ReturnCreditAmount = dlg.ReimbursementCredit;
							this.PopulateListView();
							break;
						} // end if
					} // end foreach
				} // end if
			} // end if
		}


		/// <summary>
		/// This method retrieves all the records found in the DataTable and populates   
		/// the lstUnits ListView with BloodUnits.
		/// </summary>
		/// <developers>
		///		<developer>Carl Jensen</developer>
		/// </developers>
		/// <date>11/22/02</date>
		private void SetUpListView()
		{
			foreach(System.Data.DataRow dtRow in worklistBuilder1.SelectedBloodBags.Rows) 
			{
				BOL.BloodUnit bloodUnit = new BOL.BloodUnit((System.Guid)dtRow[TABLE.BloodUnitGuid]);

				this._discardOrQuarantine.LoadBloodUnitFields(bloodUnit);
				
				_discardOrQuarantine.BloodUnits.Add(bloodUnit);
			}
			PopulateListView();
		}

		///<Developers>
		///	<Developer>Mike      </Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/13/2002</CreationDate>
		///
		/// <summary>
		/// Worklist builder control validity event handler, enables OK button when at least one unit is selected
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void CheckValid(object sender, System.EventArgs e)
		{
			btnSave.EnabledButton  = (this.worklistBuilder1.SelectedItems > 0);
		}

		/// <summary>
		/// This method populates the ListView.
		/// </summary>
		/// <developers>
		///		<developer>Carl Jensen</developer>
		/// </developers>
		/// <date>11/11/02</date>
		private void PopulateListView() 
		{
			this.lstUnits.Items.Clear();

			foreach(BOL.BloodUnit bloodUnit in _discardOrQuarantine.BloodUnits)
			{
				string[] colNames = new String[6];
				colNames[0] = bloodUnit.EyeReadableUnitId;
				colNames[1] = bloodUnit.ProductShortName;
				colNames[2] = bloodUnit.FullProductCode;
				colNames[3] = bloodUnit.BloodUnitStatus.UnitStatusText;
				// BR_27.07
				colNames[4] = GetReimbursementCost(bloodUnit).ToString("C");

				if (bloodUnit.BloodUnitStatus.QuarantineIndicator == true) colNames[5] = "Yes";
				else colNames[5] = "No";
				
				ListViewItem listViewItem = new ListViewItem(colNames);
				listViewItem.Tag = bloodUnit;
				this.lstUnits.Items.Add(listViewItem);
			}
			//
			controls.VbecsFunction.SetColumnWidths(this.lstUnits);
		}

		private decimal GetReimbursementCost(BOL.BloodUnit bloodUnit)
		{
			// The return credit amount can only be set initially in UCs 11 or 27.
			// Check to see if it's been modified in UC11.
			if (bloodUnit.BloodUnitFinance.ReturnCreditAmount > 0)
			{
				return bloodUnit.BloodUnitFinance.ReturnCreditAmount;
			}
			else
			{
				//CR1864 - Changed BloodProductGuid parameter to BloodUnitGuid parameter to handle Modification complications
				decimal percentage = BOL.ProductShipper.GetReimbursementPercentage(bloodUnit.BloodUnitGuid, bloodUnit.IncomingShipment.LocalSupplierGuid)/100;
				if (percentage > 0 && bloodUnit.BloodUnitFinance.UnitCost > 0)
				{
					if (bloodUnit.BloodUnitFinance.UnitCost > 0)
					{
						Console.WriteLine("Cost: " + percentage*bloodUnit.BloodUnitFinance.UnitCost);
						return percentage*bloodUnit.BloodUnitFinance.UnitCost;
					}
					else
					{
						return 0;
					}
				}
				return 0;
			}
		}

		/// <summary>
		/// This method populates the Discard, Quarantine and Status
		/// combo-boxes with selection data from the database.
		/// </summary>
		/// 
		/// <developers>
		///		<developer>Carl Jensen</developer>
		/// </developers>
		/// <date>11/11/02</date>
		private void PopulateCommentComboBoxes()
		{
			this._isLoading = true;

			this.cmbDiscardComment.Items.Clear();
			this.cmbDiscardComment.Items.Add(string.Empty);
			foreach(DataRow dr in _dtDiscardQuarantineDetails.Rows)
			{
				this.cmbDiscardComment.Items.Add(dr[Common.VbecsTables.CannedComment.CannedCommentText]);
			}

			this.cmbQuarantineComment.Items.Clear();
			this.cmbQuarantineComment.Items.Add(string.Empty);
			foreach(DataRow dr in _dtDiscardQuarantineDetails.Rows)
			{
				this.cmbQuarantineComment.Items.Add(dr[Common.VbecsTables.CannedComment.CannedCommentText]);
			}

			this.cmbRemoveComment.Items.Clear();
			this.cmbRemoveComment.Items.Add(string.Empty);
			foreach(DataRow dr in _dtReleaseDetails.Rows)
			{
				this.cmbRemoveComment.Items.Add(dr[Common.VbecsTables.CannedComment.CannedCommentText]);
			}

			this._isLoading = false;
		}

		private void OnValid(object sender, System.EventArgs e) 
		{
			btnSave.EnabledButton = true;
			btnSave.SetToolTip("");
		}

		private void OnInvalid(object sender, System.EventArgs e) 
		{
			btnSave.SetToolTip(_discardOrQuarantine.GetBrokenRulesMessage( "FrmDiscardQuarantine" ) );
			btnSave.EnabledButton = false;
		}

		#endregion

		#region Events
	
		/// <summary>
		/// This handles the event fired when a user selects a value from the 
		/// cmbDiscardComment combo box.
		/// </summary>
		/// <remarks>
		/// </remarks>
		/// <developers>
		///		<developer>Carl Jensen</developer>
		/// </developers>
		/// <date>11/11/02</date>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbDiscardComment_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading)
				{	
					if (cmbDiscardComment.SelectedIndex <= 0)
					{
						this._discardOrQuarantine.CommentText = string.Empty;
					}
					else
					{
						this._discardOrQuarantine.CommentText = _dtDiscardQuarantineDetails.Rows[cmbDiscardComment.SelectedIndex - 1][COMMENTS.CannedCommentText].ToString().ToUpper();
						this._discardOrQuarantine.CommentGuid = (Guid)_dtDiscardQuarantineDetails.Rows[cmbDiscardComment.SelectedIndex - 1][COMMENTS.CannedCommentGuid];
					}
							
					// details are required if "Other" is chosen as the comment 
					if(this._discardOrQuarantine.CommentText.Trim().ToUpper().Equals("OTHER"))
					{
						lblDiscardDetails.Text = "Details*";
					}
					else
					{
						lblDiscardDetails.Text = "Details";
					}
				}
			}
			catch(Exception exc)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(exc.Message));
			}
		}

		/// <summary>
		/// This handles the event fired when a user changes selected index of the 
		/// cmbQuarantineComment combo box.
		/// </summary>
		/// <remarks>
		/// </remarks>
		/// <developers>
		///		<developer>Carl Jensen</developer>
		/// </developers>
		/// <date>11/11/02</date>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbQuarantineComment_SelectedIndexChanged(object sender, System.EventArgs e)
		{	
			try
			{
				if (!this._isLoading)
				{
					if (this.cmbQuarantineComment.SelectedIndex <= 0) 
					{
						this._discardOrQuarantine.CommentText = string.Empty;
					}
					else	
					{
						this._discardOrQuarantine.CommentText = _dtDiscardQuarantineDetails.Rows[cmbQuarantineComment.SelectedIndex - 1][COMMENTS.CannedCommentText].ToString().ToUpper();
						this._discardOrQuarantine.CommentGuid = (Guid)_dtDiscardQuarantineDetails.Rows[cmbQuarantineComment.SelectedIndex - 1][COMMENTS.CannedCommentGuid];
					}

					if(this._discardOrQuarantine.CommentText.Trim().ToUpper().Equals("OTHER"))
					{
						this.lblQuarantineDetails.Text = "Details*";
					}
					else
					{
						this.lblQuarantineDetails.Text = "Details";
					}
				}
			}
			catch (Exception exc)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(exc.Message));
			}
		}

		/// <summary>
		/// This handles the event fired when a user changes selected index of the 
		/// cmbRemoveComment combo box.
		/// </summary>
		/// <remarks>
		/// </remarks>
		/// <developers>
		///		<developer></developer>
		/// </developers>
		/// <date></date>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		// CSEH: <try catch>
		private void cmbRemoveComment_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading)
				{
					if (this.cmbRemoveComment.SelectedIndex <= 0) 
					{
						this._discardOrQuarantine.CommentText = string.Empty;
					}
					else	
					{
						this._discardOrQuarantine.CommentText = _dtReleaseDetails.Rows[cmbRemoveComment.SelectedIndex - 1][COMMENTS.CannedCommentText].ToString().ToUpper();
						this._discardOrQuarantine.CommentGuid = (Guid)_dtReleaseDetails.Rows[cmbRemoveComment.SelectedIndex - 1][COMMENTS.CannedCommentGuid];
					}

					if(this._discardOrQuarantine.CommentText.Trim().ToUpper().Equals("OTHER"))
					{
						this.lblReleaseDetails.Text = "Details*";
					}
					else
					{
						this.lblReleaseDetails.Text = "Details";
					}
				}
			}
			catch (Exception exc)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(exc.Message));
			}
		}

		/// <summary>
		/// This method handles the event fired when focus leave the txtDiscardDetails texbox. 
		/// </summary>
		/// <remarks>
		/// </remarks>
		/// <developers>
		///		<developer>Carl Jensen</developer>
		/// </developers>
		/// <date>11/11/02</date>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtDiscardDetails_Leave(object sender, System.EventArgs e)
		{ 
			this._discardOrQuarantine.Details = txtDiscardDetails.Text;
		}

		/// <summary>
		/// This method handles the event fired when focus leave the txtDiscardDetails texbox. 
		/// </summary>
		/// <remarks>
		/// </remarks>
		/// <developers>
		///		<developer>Carl Jensen</developer>
		/// </developers>
		/// <date>11/11/02</date>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtDiscardDetails_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
		{ 
			this._discardOrQuarantine.Details = txtDiscardDetails.Text;
		}

		/// <summary>
		/// This method handles the event fired when a the txtQuarantineDetails textbox 
		/// loses focus.
		/// </summary>
		/// <remarks>
		/// </remarks>
		/// <developers>
		///		<developer>Carl Jensen</developer>
		/// </developers>
		/// <date>11/11/02</date>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtQuarantineDetails_Leave(object sender, System.EventArgs e)
		{
			this._discardOrQuarantine.Details = txtQuarantineDetails.Text;
		}
		
		/// <summary>
		/// This method handles the event fired when a user changes the value of the 
		/// txtQuarantineDetails textbox.
		/// </summary>
		/// <remarks>
		/// </remarks>
		/// <developers>
		///		<developer>Carl Jensen</developer>
		/// </developers>
		/// <date>11/11/02</date>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtQuarantineDetails_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			this._discardOrQuarantine.Details = txtQuarantineDetails.Text;
		}

		/// <summary>
		/// </summary>
		private void txtReleaseDetails_Leave(object sender, System.EventArgs e)
		{
			this._discardOrQuarantine.Details = txtReleaseDetails.Text;
		}

		/// <summary>
		/// </summary>
		private void txtReleaseDetails_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			this._discardOrQuarantine.Details = txtReleaseDetails.Text;
		}

		/// <summary>
		/// This handles the event fired when a user clicks the save button.  If the
		/// units are valid, they will be submitted to the database.
		/// Implements BR_27.11, BR_27.14
		/// </summary>
		/// <remarks>
		/// </remarks>
		/// <developers>
		///		<developer>Carl Jensen</developer>
		/// </developers>
		/// <date>11/11/02</date>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnSave_Click(object sender, System.EventArgs e)
		{
			ArrayList QuarantineExceptions = new ArrayList();
			//
			try
			{
				#region Handle Worklist Panel
 
				// The panel used to choose blood units is visible.  This is the first panel in the flow.
				if (pnlWorklist.Visible)
				{				
					ArrayList selectedUnits = this.worklistBuilder1.SelectedBloodUnits;
					ArrayList unitsInFinalStatusGuids = new ArrayList();
					//
					StringBuilder message = new StringBuilder();
					//
					for (int idx = 0; idx < selectedUnits.Count; idx++)
					{
						BOL.BloodUnit bloodUnit = (BOL.BloodUnit)selectedUnits[idx];
						//
						if (bloodUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.Discarded 
							|| bloodUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.Transferred 
							|| bloodUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.Transfused
							|| bloodUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.Issued) //CR 2944
						{
							string unitInfo = string.Concat(bloodUnit.EyeReadableUnitId, ", ", bloodUnit.ProductShortName);
							message.Append(Common.StrRes.InfoMsg.UC027.UnitInFinalStatusCannotBeSelected(unitInfo).ResString);
							message.Append("\n");
							//
							unitsInFinalStatusGuids.Add(bloodUnit.BloodUnitGuid);
						}
						else
						{
							this.LockController.RecordGuids.Add(bloodUnit.BloodUnitFinance.BloodUnitFinanceGuid);
                            this.LockController.RecordGuids.Add(bloodUnit.BloodUnitStatus.BloodUnitStatusGuid);
						}
					}
					//
					if (message.Length > 0 && unitsInFinalStatusGuids.Count > 0)
					{
						this.worklistBuilder1.HighlightBloodUnits(unitsInFinalStatusGuids);
						//
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.Common.Dynamic(message.ToString()));
						//
						this.worklistBuilder1.RemoveBloodUnitsFromGrid(unitsInFinalStatusGuids);
					}
					//
					if(selectedUnits.Count > unitsInFinalStatusGuids.Count)
					{
						if (!this.SetLocks())
						{
							return;
						}
						//-----------------
						this.pnlWorklist.Visible = false;
						this.pnlProcess.Visible = true;
						this.dtRemove.Visible = true;
						//
						this.SetUpListView();
						this.PopulateCommentComboBoxes();
						this.btnSave.Text = "&Save";
						this.btnSave.EnabledButton = false;
						if (this._shipmentGuid != Guid.Empty)
						{
							this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC027.FrmDiscardQuarantine_DiscardQuarantine_Shipment());
						}
						else
						{
							this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC027.FrmDiscardQuarantine_DiscardQuarantine());
						}
						//
						// set up the broken rules for the Discard panel
						this._discardOrQuarantine.SetInitialBrokenRules("FrmDiscardQuarantine");
						this._discardOrQuarantine.SetInitialState();
					}
					else
					{
						// clear the selected units because they are in final status/invalid
						this.worklistBuilder1.ClearControl();
					}	
				}

				#endregion

				#region Handle Process Panel

				// The panel used to perform an action on the blood units is visible.  This is the second panel in the flow.
				else
				{
					//CR 3195 changed this parameter to DateTime so that it could return the exact date and time of record change
					DateTime[] userDate = new DateTime[this._discardOrQuarantine.BloodUnits.Count];
					for (int idx = 0; idx < this._discardOrQuarantine.BloodUnits.Count; idx++)
					{
						userDate[idx] = DateTime.MinValue;
					}
					StringBuilder failureMessages = new StringBuilder();
					StringBuilder warningMessages = new StringBuilder();
					StringBuilder expired = new StringBuilder("The unit(s) below are expired. Continue to release expired units? \n");
					
					// Holds expired blood units attempted.  This information is needed if removal from quarantine 
					// is being attempted.
					_expiredUnits = new ArrayList();

					// Holds crossmatched units.
					_crossMatchedUnits = new ArrayList();

					// Holds units that meed all business rules.
					_validUnits = this._discardOrQuarantine.ValidateBatchSubmission(this._discardOrQuarantine.Action, failureMessages, warningMessages, _expiredUnits, _crossMatchedUnits, expired, ref userDate);

					#region Validate update date for each unit in batch

					// BR_27.14 Part 1: Level <= 2
					if (Convert.ToInt32(ThisUser.CurrentDivisionRole.Role.UserRoleId) < Convert.ToInt32(Common.UserRoleType.LeadTechnologist))
					{
						StringBuilder message = new StringBuilder();
						//
						bool showMessage = false;
						for (int idx = 0; idx < this._discardOrQuarantine.BloodUnits.Count; idx++)
						{
							BOL.BloodUnit bloodUnit = (BOL.BloodUnit)this._discardOrQuarantine.BloodUnits[idx];
							//
							//CR 2708 Added lastUpdateDate variable to match this code with the code for user level 3 and above
							//CR 3195 This code is no longer needed since we are going to use userDate variable to display in the message
							//DateTime lastUpdateDate = bloodUnit.BloodUnitStatus.LastUpdateDate.Equals(DateTime.MinValue) ? bloodUnit.LastUpdateDate : bloodUnit.BloodUnitStatus.LastUpdateDate;
							//
							if (userDate[idx] > this._discardOrQuarantine.UserDateTime)
							{
								string unitInfo = string.Concat(bloodUnit.EyeReadableUnitId, ", ", bloodUnit.ProductShortName);
								string updateDate = Common.VBECSDateTime.FormatDateTimeString(userDate[idx]);
								//
								message.Append(Common.StrRes.InfoMsg.UC027.InvalidDateNoOverride(unitInfo, updateDate).ResString);
								message.Append("\n");
								showMessage = true;
							}
						}
						//
						if (showMessage)
						{
							message.Append("\nPlease check the date/time you have entered as it is before this action and disallowed.");
							//CR 2708 Added beep to the message
							Utility.MessageBeep();
							GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.Common.Dynamic(message.ToString()));
							return;
						}
					}
					// BR_27.14 Part 2: Level >= 3
					else if (Convert.ToInt32(ThisUser.CurrentDivisionRole.Role.UserRoleId) >= Convert.ToInt32(Common.UserRoleType.LeadTechnologist))
					{
						for (int idx = 0; idx < this._discardOrQuarantine.BloodUnits.Count; idx++)
						{
							BOL.BloodUnit bloodUnit = (BOL.BloodUnit)this._discardOrQuarantine.BloodUnits[idx];
							//
							//CR 3195 This code is no longer needed since we are going to use userDate variable to display in the message
							//DateTime lastUpdateDate = bloodUnit.BloodUnitStatus.LastUpdateDate.Equals(DateTime.MinValue) ? bloodUnit.LastUpdateDate : bloodUnit.BloodUnitStatus.LastUpdateDate;
							//
							if (userDate[idx] > this._discardOrQuarantine.UserDateTime)
							{
								string unitInfo = string.Concat(bloodUnit.EyeReadableUnitId, ", ", bloodUnit.ProductShortName);
								string updateDate = Common.VBECSDateTime.FormatDateTimeString(userDate[idx]);
								//
								//CR 2708 Added beep to the message
								Utility.MessageBeep();
								DialogResult dlgResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC027.InvalidDateCanOverride(unitInfo, updateDate));
								if (dlgResult == DialogResult.Yes)
								{
									DlgOverrideComment dlg = new DlgOverrideComment("Comment required", "Please enter a comment to override", "QD");
                                    dlg.ShowDialogFromLockedParent(this, false);
									
									if (dlg.DialogResult == DialogResult.OK)       //CR3297 - changed dlgResult to dlg.DialogResult
									{
										BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Retrospective_update_prior_to_last_record_update, dlg.Comment, Common.LogonUser.LogonUserName);
										exRep.GenerateExceptionQuarantine(bloodUnit);
										QuarantineExceptions.Add(exRep);
									}
									else
									{
										return;
									}
								}
								else
								{
									return;
								}	
							}
						}
					}

					#endregion

					#region Remove from Quarantine

					// BEGIN: Removing from Quarantine
					if (this._discardOrQuarantine.Action == Common.Action.RemoveFromQuarantine)
					{
						this._workloadProcessId = Common.WorkloadProcessID.ReleaseUnitFromQuarantine;
						// BR_27.11
						// If units have expired, display a dialog box allowing user to override.
						if (_expiredUnits.Count > 0)
						{
							DialogResult saveResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.Dynamic(expired.ToString()));
							if (saveResult == DialogResult.No)
							{
								bool allUnitsExpired = _expiredUnits.Count == _validUnits.Count;
								foreach(BOL.BloodUnit bloodUnit in _expiredUnits)
								{
									_validUnits.Remove(bloodUnit);
								}
							}
							else
							{
								//CR 1441
								System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) Common.WorkloadProcessID.ReleaseUnitFromQuarantine);
								if(dt!= null)
								{
									if(dt.Rows.Count == 0)
									{
										GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
									}
								}
								DlgOverrideComment dlg = new DlgOverrideComment("Comment Required", "A comment is required to release an expired unit from quarantine.", "QR");
                                dlg.ShowDialogFromLockedParent(this, false);

								if (dlg.DialogResult == DialogResult.OK)
								{
									foreach (BOL.BloodUnit bloodUnit in this._expiredUnits)
									{
										BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Expired_unit_released_from_quarantine, dlg.Comment, Common.LogonUser.LogonUserName);
										exRep.GenerateExceptionQuarantine(bloodUnit);
										QuarantineExceptions.Add(exRep);
									}
								}
								else
								{
									foreach(BOL.BloodUnit bloodUnit in _expiredUnits)
									{
										_validUnits.Remove(bloodUnit);
									}
								}
							}
						}
						//
						// no units are valid for submission
						if (_validUnits.Count == 0 && failureMessages.Length > 0)
						{
							DialogResult saveResult2 = GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(failureMessages.ToString()));
						}
						else
						{
							if (_validUnits.Count > 0)
							{
								string message = string.Empty;
								if (failureMessages.Length > 0)
								{
									message = string.Concat(failureMessages.ToString(), "\n", this._discardOrQuarantine.BuildValidString(_validUnits));
								}
								else
								{
									message = this._discardOrQuarantine.BuildValidString(_validUnits);
								}

								foreach (BOL.BloodUnit bloodUnit in this._validUnits)
								{
									if (!this._expiredUnits.Contains(bloodUnit))
									{																		
										BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Unit_released_from_quarantine, (this.cmbRemoveComment.Text).Replace("Other", "") + " " + this.txtReleaseDetails.Text, Common.LogonUser.LogonUserName);
										exRep.GenerateExceptionQuarantine(bloodUnit);
										QuarantineExceptions.Add(exRep);
									}
								}

								//CR 2706
								DialogResult saveResult2 = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("blood unit"));
								if (saveResult2 == DialogResult.Yes)
								{
									this._discardOrQuarantine.BloodUnits = _validUnits;
									ArrayList workloadProcessIds = new ArrayList(1);
									workloadProcessIds.Add(this._workloadProcessId);					

									this._discardOrQuarantine.ChangeQuarantineStatus(QuarantineExceptions, false, Common.UpdateFunction.UC027FrmDiscardQuarantine, workloadProcessIds);
									this.DialogResult = DialogResult.OK;
									// Successful save, not dirty, close
									this.IsDirty=false;
									this.Close();
								}
							}
						}
					} 

					#endregion

					#region Quarantine or Discard
					
					// BEGIN: Quarantining or Discarding
					else
					{
						// no units are valid for submission
						if (_validUnits.Count == 0) 
						{
							if (failureMessages.Length == 0) failureMessages.Append("No units are valid for submission.");
							DialogResult saveResult2 = GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(failureMessages.ToString()));		
						}
						else
						{
							string message = string.Empty;
							if (failureMessages.Length > 0)
							{
								message = string.Concat(failureMessages.ToString(), "\n", this._discardOrQuarantine.BuildValidString(_validUnits));
							}
							else
							{
								message = this._discardOrQuarantine.BuildValidString(_validUnits);
							}
							//
							if( warningMessages.Length > 0 )
							{
								GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.Common.Dynamic(string.Concat(warningMessages.ToString())));	
							}
							//
							//CR 2706
							DialogResult saveResult2 = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("blood unit"));
							if (saveResult2 == DialogResult.Yes)
							{
								switch (this._discardOrQuarantine.Action)
								{
									case Common.Action.Quarantine:
									{
										this._workloadProcessId = Common.WorkloadProcessID.QuarantineUnit;
										//CR 1441
										System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) Common.WorkloadProcessID.QuarantineUnit);
										if(dt!= null)
										{
											if(dt.Rows.Count == 0)
											{
												GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
											}
										}
										foreach (BOL.BloodUnit bloodUnit in this._validUnits)
										{
											BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Unit_quarantined, this.cmbQuarantineComment.Text + ". " + this.txtQuarantineDetails.Text, Common.LogonUser.LogonUserName);
											exRep.GenerateExceptionQuarantine(bloodUnit);
											QuarantineExceptions.Add(exRep);
										}

										this._discardOrQuarantine.BloodUnits = _validUnits;
										ArrayList workloadProcessIds = new ArrayList(1);
										workloadProcessIds.Add(this._workloadProcessId);
										this._discardOrQuarantine.ChangeQuarantineStatus(QuarantineExceptions, true, Common.UpdateFunction.UC027FrmDiscardQuarantine, workloadProcessIds);
										// Successful update, not dirty, close
										this.IsDirty = false;
										this.Close();
										break;
									}
									case Common.Action.Discard:
									{
										this._workloadProcessId = Common.WorkloadProcessID.DiscardUnit;
										//CR 1441
										System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) Common.WorkloadProcessID.DiscardUnit);
										if(dt!= null)
										{
											if(dt.Rows.Count == 0)
											{
												GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
											}
										}
										foreach (BOL.BloodUnit bloodUnit in this._validUnits)
										{
											BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Unit_discarded, this.cmbDiscardComment.Text + ". " + this.txtDiscardDetails.Text, Common.LogonUser.LogonUserName);
											exRep.GenerateExceptionQuarantine(bloodUnit);
											QuarantineExceptions.Add(exRep);
										}

										this._discardOrQuarantine.BloodUnits = _validUnits;
										this._discardOrQuarantine.ChangeDiscardStatus(QuarantineExceptions, this._discardOrQuarantine.DiscardDisposition == Common.DiscardDisposition.Credit, Common.UpdateFunction.UC027FrmDiscardQuarantine, this._workloadProcessId);
										// Successful update, not dirty, close
										this.IsDirty=false;
										this.Close();
										break;
									}
								} // switch
							}  // if
						} // else
					} // else
				} // else

				#endregion

				#endregion
			}
			catch (RowVersionException)
			{
				this.btnSave.RowVersionException = true;		//CR2077
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
			}
		}

		/// <summary>
		/// This handles the event fired when a user hovers over the save button.
		/// </summary>
		/// <remarks>
		/// </remarks>
		/// <developers>
		///		<developer>Carl Jensen</developer>
		/// </developers>
		/// <date>11/11/02</date>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnSave_AnotherHover(object sender, System.EventArgs e)
		{
			string _form = "FrmDiscardQuarantine";
			btnSave.SetToolTip( _discardOrQuarantine.GetBrokenRulesMessage( _form ) );
		}

		/// <summary>
		/// This handles the event fired when a user clicks the Discard radio button.
		/// </summary>
		/// <remarks>
		/// </remarks>
		/// <developers>
		///		<developer>Carl Jensen</developer>
		/// </developers>
		/// <date>11/11/02</date>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void rdoDiscard_Click(object sender, System.EventArgs e)
		{
			this._discardOrQuarantine.SetInitialBrokenRules("FrmDiscardQuarantine");
			this._discardOrQuarantine.SetInitialState();

			grpDiscard.Visible = rdoDiscard.Checked;
			grpQuarantine.Visible = rdoQuarantine.Checked;
			grpRelease.Visible = rdoRelease.Checked;

			this.cmbDiscardComment.SelectedIndex = -1;
			this.cmbDiscardComment.SelectedText = String.Empty;
			this.txtDiscardDetails.Text = string.Empty;

			this._discardOrQuarantine.Action = Common.Action.Discard;
			this._discardOrQuarantine.CommentText = string.Empty;
			this._discardOrQuarantine.Details = string.Empty;
	
			// Force trigger of broken rule since the date could have been changed already, but the broken
			// rules have been reset:
			this._discardOrQuarantine.UserDateTime = this.dtDiscard.Value;
		}

		/// <summary>
		/// This handles the event fired when a user clicks the Quarantine radio button.
		/// </summary>
		/// <remarks>
		/// </remarks>
		/// <developers>
		///		<developer>Carl Jensen</developer>
		/// </developers>
		/// <date>11/11/02</date>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void rdoQuarantine_Click(object sender, System.EventArgs e)
		{
			this._discardOrQuarantine.SetInitialBrokenRules("FrmDiscardQuarantine");
			this._discardOrQuarantine.SetInitialState();

			grpDiscard.Visible = rdoDiscard.Checked;
			grpQuarantine.Visible = rdoQuarantine.Checked;
			grpRelease.Visible = rdoRelease.Checked;

			this.cmbQuarantineComment.SelectedIndex = -1;
			this.cmbQuarantineComment.SelectedText = String.Empty;
			this.txtQuarantineDetails.Text = string.Empty;

			this._discardOrQuarantine.Action = Common.Action.Quarantine;
			this._discardOrQuarantine.CommentText = string.Empty;
			this._discardOrQuarantine.Details = String.Empty;

			// Force trigger of broken rule since the date could have been changed already, but the broken
			// rules have been reset:
			this._discardOrQuarantine.UserDateTime = this.dtQuarantine.Value;
		}


		/// <summary>
		/// This handles the event fired when a user clicks the Release radio button.
		/// </summary>
		/// <remarks>
		/// </remarks>
		/// <developers>
		///		<developer>Carl Jensen</developer>
		/// </developers>
		/// <date>11/11/02</date>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void rdoRelease_Click(object sender, System.EventArgs e)
		{
			this._discardOrQuarantine.SetInitialBrokenRules("FrmDiscardQuarantine");
			this._discardOrQuarantine.SetInitialState();

			grpDiscard.Visible = rdoDiscard.Checked;
			grpQuarantine.Visible = rdoQuarantine.Checked;
			grpRelease.Visible = rdoRelease.Checked;

			this.cmbRemoveComment.SelectedIndex = -1;
			this.cmbRemoveComment.SelectedText = String.Empty;
			this.txtReleaseDetails.Text = string.Empty;

			this._discardOrQuarantine.Action = Common.Action.RemoveFromQuarantine;
			this._discardOrQuarantine.CommentText = string.Empty;
			this._discardOrQuarantine.Details = String.Empty;

			// Force trigger of broken rule since the date could have been changed already, but the broken
			// rules have been reset:
			this._discardOrQuarantine.UserDateTime = this.dtRemove.Value;
		}


		/// <summary>
		/// This handles the event fired when a user clicks the Waste (Discard only) radio 
		/// button.
		/// </summary>
		/// <remarks>
		/// </remarks>
		/// <developers>
		///		<developer>Carl Jensen</developer>
		/// </developers>
		/// <date>11/11/02</date>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void rdoWaste_Click(object sender, System.EventArgs e)
		{
			this._discardOrQuarantine.DiscardDisposition = Common.DiscardDisposition.Waste;
		}


		/// <summary>
		/// This handles the event fired when a user clicks the Credit (Discard only) radio 
		/// button.
		/// </summary>
		/// <remarks>
		/// </remarks>
		/// <developers>
		///		<developer>Carl Jensen</developer>
		/// </developers>
		/// <date>11/11/02</date>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void rdoCredit_Click(object sender, System.EventArgs e)
		{
			this._discardOrQuarantine.DiscardDisposition = Common.DiscardDisposition.Credit;
		}

		/// <summary>
		/// This handles the click event of the Cancel button and closes out this form
		/// </summary>
		/// <developers>
		///		<developer>Carl Jensen</developer>
		/// </developers>
		/// <date>9/7/02</date>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.Close();
		}

		private void dtRemove_ValueChanged(object sender, System.EventArgs e)
		{
			if(!this._isLoading)
			{
				this._discardOrQuarantine.UserDateTime = dtRemove.Value;
			}
		}

		private void dtQuarantine_ValueChanged(object sender, System.EventArgs e)
		{
			if(!this._isLoading)
			{
				this._discardOrQuarantine.UserDateTime = dtQuarantine.Value;
			}
		}

		private void dtDiscard_ValueChanged(object sender, System.EventArgs e)
		{
			if(!this._isLoading)
			{
				this._discardOrQuarantine.UserDateTime = dtDiscard.Value;
			}
		}
		
		/// <summary>
		/// Enables the OK button once the worklist is validated
		/// </summary>
		/// <developers>
		///		<developer>Carl Jensen</developer>
		/// </developers>
		/// <date>11/11/02</date>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void worklistBuilder1_ValidWorklist(object sender, System.EventArgs e)
		{
			this.btnSave.EnabledButton = true;
		}

		/// <summary>
		/// Disables the OK button if the worklist is invalid
		/// </summary>
		/// <developers>
		///		<developer>Carl Jensen</developer>
		/// </developers>
		/// <date>11/11/02</date>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void worklistBuilder1_InvalidWorklist(object sender, System.EventArgs e)
		{
			this.btnSave.EnabledButton = false;
		}

		private void worklistBuilder1_SearchClick(object sender, System.EventArgs e)
		{
			using ( new WaitCursor() ) 
			{
				try
				{
					DataTable eligDt = BOL.DiscardOrQuarantineBloodUnit.GetDiscardOrQuarantineUnits();
					//
					DlgSelectBloodUnits unitSelector = new DlgSelectBloodUnits(eligDt, this.worklistBuilder1.bloodUnitSelector1.EnteredEyeReadableUnitId, this.worklistBuilder1.bloodUnitSelector1.EnteredUnitProductCode);
					unitSelector.MultiSelect = true;
					unitSelector.TitleBarText = "VBECS - Select Unit for Discard or Quarantine";
					unitSelector.LogoBarText = "Select Unit for Discard or Quarantine";

					unitSelector.ShowDialogFromLockedParent(this,false);
					//
					if (unitSelector.DialogResult == DialogResult.OK)
					{
						this.worklistBuilder1.ResetSelectorFieldsAndErrors();
						if (unitSelector.SelectedUnits.Rows.Count > 1) 
						{
							foreach (DataRow dr in unitSelector.SelectedUnits.Rows)
							{ 
								BOL.BloodUnit bloodUnit = new BOL.BloodUnit((System.Guid)dr[TABLE.BloodUnitGuid]);
								// 
								this.worklistBuilder1.PopulateGrid(bloodUnit);
							}
						}
						else
						{
							if (unitSelector.SelectedUnits.Rows.Count == 1)
							{
								DataRow dr = unitSelector.SelectedUnits.Rows[0];
								this.worklistBuilder1.bloodUnitSelector1.PopulateSelector(dr[TABLE.EyeReadableUnitId].ToString(), dr[Common.DatabaseConstants.ArtificialColumnNames.FullProductCode].ToString());
							}
						}
					}
				}
				catch (Exception err)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.CannotCreateSearchTool(err.Message));
				}
			}
		}

		private void worklistBuilder1_ItemCheck(object sender, System.EventArgs e)
		{
			btnSave.EnabledButton = (this.worklistBuilder1.SelectedItems > 0);
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmDiscardQuarantine_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;
			//
			if ( this.pnlWorklist.Visible 
				&& !this.btnSave.EnabledButton 
				&& !this.worklistBuilder1.bloodUnitSelector1.SelectButtonEnabled )
			{
				if ( this.worklistBuilder1.bloodUnitSelector1.txtUnitID == null ||
					this.worklistBuilder1.bloodUnitSelector1.txtUnitID.Text == string.Empty )
				{
					textToSpeak = "Select Unit ID ";
				}
				if ( this.worklistBuilder1.bloodUnitSelector1.txtProductID == null ||
					this.worklistBuilder1.bloodUnitSelector1.txtProductID.Text == string.Empty )
				{
					textToSpeak = textToSpeak.Length > 0 ? string.Concat(textToSpeak, " and Product ") : "Select Product ";
				}
				//
				textToSpeak = textToSpeak.Length > 0 ? string.Concat(textToSpeak, " to continue.") : string.Empty;
			}	
			else if ( this.pnlProcess.Visible && !this.btnSave.EnabledButton )
			{
				textToSpeak = _discardOrQuarantine.GetBrokenRulesMessage( "FrmDiscardQuarantine" );
			}
			// Also get the error provider messages for the BloodUnitSelector control
			textToSpeak = string.Concat(textToSpeak, "\n", this.worklistBuilder1.bloodUnitSelector1.GetErrorMessages());
			//
			this.SpeakMessage( textToSpeak );
		}
	}

	#endregion
}
